<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'snapshot' OR empty($_REQUEST['action']))
{
	$snapshots = VBSECURITY::$db->fetchAssoc('SELECT snapshotid, dateline FROM $dbtech_vbsecurity_snapshot');

	print_cp_header($vbphrase['dbtech_vbsecurity_snapshot_management']);

	// Table header
	$headings = array();
	$headings[] = $vbphrase['date'];
	$headings[] = $vbphrase['dbtech_vbsecurity_load_snapshot'];
	$headings[] = $vbphrase['delete'];

	if (count($snapshots))
	{
		print_form_header('', '');
		print_table_header($vbphrase['dbtech_vbsecurity_snapshot_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsecurity_snapshot_management_descr'], false, count($headings));

		print_cells_row($headings, 0, 'thead');

		foreach ($snapshots as $snapshotid => $snapshot)
		{
			// Table data
			$cell = array();
			$cell[] = vbdate($vbulletin->options['logdateformat'], $snapshot['dateline']);
			$cell[] = construct_link_code($vbphrase['dbtech_vbsecurity_load_snapshot'], 'vbsecurity.php?' . $vbulletin->session->vars['sessionurl'] . 'do=snapshot&amp;action=load&amp;snapshotid=' . $snapshotid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbsecurity.php?' . $vbulletin->session->vars['sessionurl'] . 'do=snapshot&amp;action=delete&amp;snapshotid=' . $snapshotid);

			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_table_footer();
	}
	else
	{
		print_form_header('', '');
		print_table_header($vbphrase['dbtech_vbsecurity_snapshot_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsecurity_no_snapshots'], false, count($headings));
		print_table_footer();
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'snapshotid', TYPE_UINT);

	print_cp_header(construct_phrase($vbphrase['dbtech_vbsecurity_delete_x'], $vbphrase['dbtech_vbsecurity_snapshot']));
	print_delete_confirmation('dbtech_vbsecurity_snapshot', $vbulletin->GPC['snapshotid'], 'vbsecurity', 'snapshot', 'dbtech_vbsecurity_snapshot', array('action' => 'kill'), '', 'snapshotid');
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'snapshotid', TYPE_UINT);
	if (!$existing = VBSECURITY::$db->fetchRow('SELECT * FROM $dbtech_vbsecurity_snapshot WHERE snapshotid = ?', array($vbulletin->GPC['snapshotid'])))
	{
		// Couldn't find the snapshot
		print_stop_message('dbtech_vbsecurity_invalid_x', $vbphrase['dbtech_vbsecurity_snapshot'], $existing['snapshotid']);
	}

	// Delete the snapshot
	VBSECURITY::$db->delete('dbtech_vbsecurity_snapshot', 'WHERE snapshotid = ' . intval($vbulletin->GPC['snapshotid']));

	define('CP_REDIRECT', 'vbsecurity.php?do=snapshot');
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['dbtech_vbsecurity_snapshot'], $vbphrase['dbtech_vbsecurity_deleted']);
}

// #############################################################################
if ($_REQUEST['action'] == 'load')
{
	$vbulletin->input->clean_gpc('r', 'snapshotid', TYPE_UINT);
	if (!$existing = VBSECURITY::$db->fetchRow('SELECT * FROM $dbtech_vbsecurity_snapshot WHERE snapshotid = ?', array($vbulletin->GPC['snapshotid'])))
	{
		// Couldn't find the snapshot
		print_stop_message('dbtech_vbsecurity_invalid_x', $vbphrase['dbtech_vbsecurity_snapshot'], $vbulletin->GPC['snapshotid']);
	}

	print_cp_header($vbphrase['dbtech_vbsecurity_load_snapshot']);
	print_confirmation(construct_phrase(
		$vbphrase['are_you_sure_want_to_load_snapshot_x'], $existing['snapshotid'], vbdate($vbulletin->options['logdateformat'], $existing['dateline'])
	), 'vbsecurity', 'snapshot', array('action' => 'doload', 'snapshotid' => $existing['snapshotid']));
}

// #############################################################################
if ($_POST['action'] == 'doload')
{
	$vbulletin->input->clean_gpc('r', 'snapshotid', TYPE_UINT);
	if (!$existing = VBSECURITY::$db->fetchRow('SELECT * FROM $dbtech_vbsecurity_snapshot WHERE snapshotid = ?', array($vbulletin->GPC['snapshotid'])))
	{
		// Couldn't find the snapshot
		print_stop_message('dbtech_vbsecurity_invalid_x', $vbphrase['dbtech_vbsecurity_snapshot'], $vbulletin->GPC['snapshotid']);
	}
	$existing['data'] = unserialize($existing['data']);

	require_once(DIR . '/includes/adminfunctions_options.php');
	if (!empty($existing['data']))
	{
		save_settings($existing['data']);
	}

	define('CP_REDIRECT', 'vbsecurity.php?do=snapshot');
	print_stop_message('dbtech_vbsecurity_x_y', $vbphrase['dbtech_vbsecurity_snapshot'], $vbphrase['dbtech_vbsecurity_loaded']);
}

print_cp_footer();